-- JFD_RwF_Functions
-- Author: JFD
-- DateCreated: 30/10/2016 
--==========================================================================================================================
-- INCLUDES
--==========================================================================================================================
include("Civ6Common.lua");
include("InstanceManager.lua");
include("SupportFunctions.lua");
--==========================================================================================================================
-- JFD
--==========================================================================================================================
--Triggering certain nested functions doesn't work in custom Lua, it seems - so we put it here sneaky sneaky!
--==========================================================================================================================
-- UTILITY FUNCTIONS
--==========================================================================================================================
--JFD_GetUserSetting
function JFD_GetUserSetting(type)
	for row in GameInfo.JFD_GlobalUserSettings() do
		if row.Type == type then
			return row.Value
		end
	end
end

--JFD_IsFeminine
function JFD_IsFeminine(playerTypeName)
	for row in GameInfo.Leader_Titles() do
		if (row.LeaderType == playerTypeName and (not row.LeaderTitle)) then
			return row.UseFeminine
		end
	end
	return false
end

--JFD_GetDefaultLeaderName
function JFD_GetDefaultLeaderName(playerTypeName)
	for row in GameInfo.Leaders() do
		if row.LeaderType == playerTypeName then
			return row.Name
		end
	end
end

--JFD_GetCultureType
function JFD_GetCultureType(playerID)
	local player = Players[playerID]
	local playerConfig = PlayerConfigurations[playerID]
	local civTypeName = playerConfig:GetCivilizationTypeName()
	local cultureType = "CULTURE_JFD_WEST_EUROPEAN"	
	for row in GameInfo.Civilization_JFD_CultureType() do
		if row.CivilizationType == civTypeName then
			cultureType = row.CultureType
		end
	end	
	return cultureType
end
--==========================================================================================================================
-- USER SETTINGS
--==========================================================================================================================
local userSettingGovernmentTitles = JFD_GetUserSetting("JFD_RWF_GOVERNMENT_CORE_GOVERNMENT_TITLES") == 1
local userSettingLeaderTitles 	  = JFD_GetUserSetting("JFD_RWF_GOVERNMENT_CORE_LEADER_TITLES") == 1
--==========================================================================================================================
-- CORE FUNCTIONS
--==========================================================================================================================
-- GOVERNMENT
----------------------------------------------------------------------------------------------------------------------------
--JFD_RwF_GovernmentChanged
function JFD_RwF_GovernmentChanged(playerID, governmentID)
	local player = Players[playerID]
	local playerConfig = PlayerConfigurations[playerID]
	local playerTypeName = playerConfig:GetLeaderTypeName()
	local playerName = JFD_GetDefaultLeaderName(playerTypeName)
	local governmentData = GameInfo.Governments[governmentID]
	local governmentLeaderTitle = governmentData.LeaderTitle
	local isFeminine = JFD_IsFeminine(playerTypeName)
	local playerReligion = player:GetReligion()
	if playerReligion then 
		local religionType = playerReligion:GetReligionTypeCreated()
		--Religion-specific
		if religionType > 0 then
			for row in GameInfo.Religion_Titles() do
				if (row.LeaderTitle and GameInfo.Religions[religionType].ReligionType == row.ReligionType and row.GovernmentType == governmentData.GovernmentType) then
					governmentLeaderTitle = row.LeaderTitle
					break
				end
			end
		end 
	end
	if isFeminine then governmentLeaderTitle = governmentLeaderTitle .. "_FEMININE" end
	--Leader-specific
	if userSettingLeaderTitles then
		for row in GameInfo.Leader_Titles() do
			if (row.LeaderTitle and row.LeaderType == playerTypeName and row.GovernmentType == governmentData.GovernmentType) then
				governmentLeaderTitle = row.LeaderTitle
				break
			end
		end
	end
	if governmentLeaderTitle then
		playerConfig:SetLeaderName(Locale.Lookup(governmentLeaderTitle) .. " " .. Locale.Lookup(playerName))
	end
	--JFD Leader name
	Controls.LeaderName:SetText(Locale.Lookup(PlayerConfigurations[m_ePlayer]:GetLeaderName()))
end	
if userSettingGovernmentTitles then
	-- Events.GovernmentChanged.Add(JFD_RwF_GovernmentChanged)
end

--JFD_RwF_GovernmentPolicyChanged
function JFD_RwF_GovernmentPolicyChanged(playerID, policyID)
	local player = Players[playerID]
	local playerConfig = PlayerConfigurations[playerID]
	local playerTypeName = playerConfig:GetLeaderTypeName()
	local playerName = JFD_GetDefaultLeaderName(playerTypeName)
	local policyData = GameInfo.Policies[policyID]
	local governmentLeaderTitle = nil
	for row in GameInfo.Policy_Titles() do
		if (row.LeaderTitle and row.PolicyType == policyData.PolicyType) then
			governmentLeaderTitle = row.LeaderTitle
			break
		end
	end
	local isFeminine = JFD_IsFeminine(playerTypeName)
	if isFeminine then governmentLeaderTitle = governmentLeaderTitle .. "_FEMININE" end
	--Leader-specific
	if userSettingLeaderTitles then
		for row in GameInfo.Leader_Titles() do
			if (row.LeaderTitle and row.LeaderType == playerTypeName and row.PolicyType and row.PolicyType == policyData.PolicyType) then
				governmentLeaderTitle = row.LeaderTitle
				break
			end
		end
	end
	if governmentLeaderTitle then
		playerConfig:SetLeaderName(Locale.Lookup(governmentLeaderTitle) .. " " .. Locale.Lookup(playerName))
	end
	--JFD Leader name
	Controls.LeaderName:SetText(Locale.Lookup(PlayerConfigurations[m_ePlayer]:GetLeaderName()))
end	
if userSettingGovernmentTitles then
	-- Events.GovernmentPolicyChanged.Add(JFD_RwF_GovernmentPolicyChanged)
end
--==========================================================================================================================
--==========================================================================================================================